/*
func altera_opt_area_max( args size) {
 abstract gatetype gg

 switch (upper @size) {
      SMALL  {
               gg = (findgatetype (cat @Techdef.libname ":" INV))
               gg.%origcost = @gg._cost
               gg._cost = 10
               gg = (findgatetype (cat @Techdef.libname ":" NAND6))
               gg.%origcost = @gg._cost
               gg._cost = 0
             }
      LARGE  {
               gg = (findgatetype (cat @Techdef.libname ":" COMB))
               gg.%origcost = @gg._cost
               gg._cost = 1000
               gg = (findgatetype (cat @Techdef.libname ":" NAND6))
               gg.%origcost = @gg._cost
               gg._cost = 700
             }
      }
  #opt_area high
  opt_area  medium 
  altera_collapse_COMB
  switch (upper @size) {
      SMALL  {
               gg = (findgatetype (cat @Techdef.libname ":" INV))
               gg._cost = @gg.%origcost
               gg = (findgatetype (cat @Techdef.libname ":" NAND6))
               gg._cost = @gg.%origcost
             }
      LARGE  {
               gg = (findgatetype (cat @Techdef.libname ":" COMB))
               gg._cost = @gg.%origcost
               gg = (findgatetype (cat @Techdef.libname ":" NAND6))
               gg._cost = @gg.%origcost
             }
      }
}
*/
func altera_opt_area_max(args size) {
list ll
 switch  @Netlist._env.fpga_tech {
          
          MAX5000 { ll = (altera_opt_area_max5000) 
                    altera_opt_area_main @size @ll
                  }
          MAX7000 { ll = (altera_opt_area_max7000)
                    altera_opt_area_main @size @ll
                  }
          FLEX8000 { println "FLEX8000 is not supported in this recipe"}
      }
}

func altera_opt_area_max5000 {
 list instlist 
    instlist = '( (SMALL ((INV 10) ( NAND6 0))) (LARGE ((COMB 1000) (NAND6 700))))
    return @instlist
}
func altera_opt_area_max7000 {
 list instlist
    instlist = '( (SMALL ((INV 10) ( NAND6 0))) (LARGE ((COMB2 1000) (NOR6 0) (AND6 0) )))
    #instlist = '( (SMALL ((INV 10) ( NAND6 0))) (LARGE ((COMB 1000) (NOR6 500) (AND6 500))))
    return @instlist
}


func  altera_opt_area_main (string size; list gglist){
list ll ll2
abstract gatetype gg
                ll = @gglist.(upper @size)
                foreach ll2 @ll {
                          gg = (findgatetype (cat @Techdef.libname ":" @ll2[0]))
                          gg.%origcost = @gg._cost
                          gg._cost = @ll2[1] 
                }
               #opt_area high
                opt_area medium 
               altera_combff_opt
               foreach ll2 @ll {
                        gg = (findgatetype (cat @Techdef.libname ":" @ll2[0]))
                        gg._cost = @gg.%origcost
               }
               altera_collapse_COMB
}
/*

func altera_collapse_comb_COMB (abstract instance ii) {
list glist

        glist = (bld @ii)
        pushdesign
        if(lo_specifycutlist @glist) {
                docut
                flattenmodel 1 
                opt_quick
                splicecut
         }
        popdesign
}

*/
func altera_collapse_comb_COMB (abstract instance ii) {
list glist
abstract gatetype ggxor ggor
list sigor sigxor soft
abstract net nn
abstract connection cc
string str
int x
        switch (@ii._gatetype._name) {
             COMB {  ggor = (findgatetype (cat ALTERA_LIB ":" OR3 )) }
             COMB2 { ggor = (findgatetype (cat ALTERA_LIB ":" OR4)) } 
        }
        ggxor = (findgatetype (cat ALTERA_LIB ":" XOR2))
        sigor = sigxor = '()
        foreach cc (inputs @ii) {
             if ( (substr @cc._portname 0 2) == I0) {
                      append sigxor (bld @cc._portname @cc._net)
             } else {
                     str = (substr @cc._portname 1 2)
                     fscanf @str "%d" x
                     x--
                     append sigor (bld (cat I @x) @cc._net)
             }
                  
       }
       nn = (addnet @Netlist)
       append sigor  (bld OUT @nn)
       append sigxor (bld I1 @nn)
       foreach cc (outputs @ii) ( append sigxor (bld OUT @cc._net))
       addinstance @Netlist @ggxor._view @sigxor
       addinstance @Netlist @ggor._view @sigor
       deleteinstance @Netlist @ii 
       lo_namenets
}


func altera_collapse_seq_COMB (abstract instance ii) {
list comblist seqlist soft
abstract connection cc
abstract net nn
abstract instance jj
abstract gatetype ggsoft

         comblist = soft = seqlist = '()
          foreach cc (conns @ii) {
                 if ( (substr @cc._portname 0 1) == I){
        	          append comblist (bld @cc._portname @cc._net)    
                 } else {
                          append seqlist (bld @cc._portname @cc._net)
                 }
          }
          ggsoft = (findgatetype (cat ALTERA_LIB ":" SOFT))
          nn = (addnet @Netlist)
          append comblist (bld O @nn)
          addinstance @Netlist (altera_get_COMB_view @ii COMB) @comblist
  
          append seqlist (bld D @nn)
          jj = (addinstance @Netlist (altera_get_COMB_view @ii SEQ) @seqlist )

          cc = (findconn @jj Q)
          append soft (bld A_OUT @cc._net) 
          nn = (addnet @Netlist) 
          append soft (bld A_IN @nn)           
          cc._net = @nn
          addinstance @Netlist @ggsoft._view @soft
          deleteinstance @Netlist @ii
}

func altera_collapse_port_COMB (abstract instance ii) {
list comblist seqlist soft
abstract connection cc
abstract net nn
abstract instance jj
abstract gatetype ggsoft

          comblist = soft =  '()
          ggsoft = (findgatetype (cat @Techdef.libname ":" SOFT))
          foreach cc (conns @ii) {
                     append comblist (bld @cc._portname @cc._net)
          }
          jj = (addinstance @Netlist (altera_get_COMB_view @ii COMB) @comblist)

          cc = (findconn @jj O)
          append soft (bld A_OUT @cc._net)
          nn = (addnet @Netlist)
          append soft (bld A_IN @nn)
          cc._net = @nn 
          addinstance @Netlist @ggsoft._view @soft
          deleteinstance  @Netlist  @ii
}


func altera_get_COMB_view (abstract instance ii; string typ){
string name
abstract gatetype gg 
        switch (upper @typ){

               SEQ {
                        switch (upper @ii._gatetype._name) { 
   				  COMBDFF  COMB2DFF  { name = DFF }
                                  COMBDFFE COMB2DFFE { name = DFFE } 
                         } 
                   }
              COMB {
                         switch (upper @ii._gatetype._name) {
                                  COMBP COMBDFF  COMBDFFE  { name = COMB }
                                  COMB2P COMB2DFF COMB2DFFE { name = COMB2 }
                         } 
                   }
        }
     gg = (findgatetype (cat @Techdef.libname ":" @name))
     return @gg._view
}
func altera_collapse_COMB {
       list  comblist
       list  COMBgt COMBSEQgt COMBPORTgt
       abstract instance ii

       COMBgt = '( COMB COMB2)
       COMBSEQgt = '(COMBDFF COMBDFFE COMB2DFF COMB2DFFE)
       COMBPORTgt = '(COMBP COMB2P)
       comblist = '()
       foreach ii(instances @Netlist){
            if ((isinlist @ii._gatetype._name @COMBSEQgt)) (append comblist @ii)
       }
       foreach ii @comblist { altera_collapse_seq_COMB @ii }
       comblist = '()
       foreach ii(instances @Netlist){
            if ((isinlist @ii._gatetype._name @COMBPORTgt)) (append comblist @ii)
       }
       foreach ii @comblist { altera_collapse_port_COMB @ii }
       comblist = '()
       foreach ii(instances @Netlist){
            if ((isinlist @ii._gatetype._name @COMBgt)) (append comblist @ii)
       }
       foreach ii @comblist { altera_collapse_comb_COMB @ii }
       cleanup @Netlist
       lo_namenets
}


func altera_combff_opt {
 abstract gatetype gg
 string name
 
     if (! @Netlist._hasnoncombprims) (return) 
     flattenopt 1
      switch  @Netlist._env.fpga_tech {
         MAX5000 { name = COMB }
         MAX7000 { name = COMB2 }
      }
      gg = (findgatetype (cat @Techdef.libname ":" @name))
      gg.%tmpcost = @gg._cost
      gg._cost = 10
      merge_gates 
      altera_opt_area_COMB
      #map_combinational
      altera_replace_DFF_with_COMBDFF 
      altera_make_PORTCOMB
      gg._cost = @gg.%tmpcost
      flattenopt 1
      altera_factor
      #opt_area high nofactor
      opt_area medium nofactor
}

func altera_make_PORTCOMB {
abstract instance pp 
list instlist siglist dellist
abstract connection cc cc2


 dellist = '()
 instlist = '(COMB COMB2)
 foreach pp (ports @Netlist) {

      switch(@pp._portdir){
        case O B  {
                     foreach cc (outputs @pp._portnet) {}
                     if (isinlist @cc._instance._gatetype._name @instlist){
                             siglist = '()
                             foreach cc2 (conns @cc._instance) {
 				append siglist (bld @cc2._portname  @cc2._net)
                             }
                             addinstance @Netlist (altera_set_PORTCOMB_view @cc2._instance) @siglist
                             append dellist @cc2._instance
                     }

     }
    }
   }
   foreach pp @dellist { deleteinstance @Netlist @pp }

}
func altera_set_PORTCOMB_view (abstract instance ii){
     abstract gatetype gg

             gg = (findgatetype (cat @Techdef.libname ":" \
                     (upper (cat @ii._gatetype._name P))))
             return @gg._view
 
}
func altera_replace_DFF_with_COMBDFF {

  list instlist ilist comblist siglist
  abstract instance ii jj
  abstract connection cc cc2

        instlist = '(DFF DFFE)
        comblist = '(COMB COMB2)
        ilist = '()
        foreach ii (instances @Netlist) {
                 if ( (isinlist @ii._gatetype._name @instlist )) ( append  ilist @ii)
        }
        #println @ilist
        foreach ii @ilist { 
                       siglist = '()    
                       cc = ( findconn @ii D) 
                       foreach cc2 (outputs @cc._net) {}
                       jj = @cc2._instance
                       if ( !(isinlist @jj._gatetype._name @comblist )) (continue)
                       if (@cc._net._numinputs > 1) {
			 jj = (altera_duplicate_instance @jj @cc)
                         foreach cc2 (outputs @jj) {}
                         cc._net = @cc2._net
                       }
                       foreach cc2 (inputs @jj){
                          append siglist (bld @cc2._portname @cc2._net)
                       }
                       foreach cc2 (conns @ii){
                          if (@cc2._portname == D) (continue)
			  append siglist (bld @cc2._portname @cc2._net)
                       }
                      
                       addinstance @Netlist (altera_set_COMB_view @ii @jj) @siglist 
                       deleteinstance @Netlist @ii 
                       deleteinstance @Netlist @jj 
                   } 

}

func altera_set_COMB_view (abstract instance ii1 ii2){

abstract gatetype gg
     
             gg = (findgatetype (cat @Techdef.libname ":" \
                     (upper (cat @ii2._gatetype._name @ii._gatetype._name))))
             return @gg._view

}
func altera_duplicate_instance (abstract instance ii; abstract connection ccii) {
#duplicate COMB instance
# duplicate instance with one output only

abstract instance jj
abstract connection cc cc2
list siglist 
abstract net nn
                siglist = '()   
                foreach cc (outputs @ii) {}
                if (@cc._net._numinputs > 1) {
                    foreach cc2 (inputs @ii) {
                         append siglist (bld @cc2._portname @cc2._net)
                    }
                    nn = (addnet @Netlist)
                    append siglist ( bld @cc._portname @nn) 
                    jj = (addinstance @Netlist @ii._gatetype._view @siglist)
                } 
 return @jj 
}

func altera_factor() {
   int timing
        quick_factor
        timing = @Opt.timingenabled
        lo_factor_setup
        shortgates
        pushinv
        factor_change_ors_to_ands
        popinv
        lo_factor_cleanup @timing
}

func altera_tag_COMB() {

     abstract instance gt ii
     abstract connection cc cc2

     foreach gt (instances @Netlist) {
             if(!(isinlist @gt._gatetype._name @combgates)) (continue)
             foreach cc (outputs @gt) {
                  foreach cc2 (inputs @cc._net) {
                  ii = @cc2._instance      
                  if(!(instr  @ii._gatetype._flags Bx)) (continue)
                  if( !(@ii._isport)) (continue)
                  gt.%alttag = 1
                 }
             } 
             
     }

}
func altera_opt_area_COMB() {
        abstract instance gt
        list seqgates combgates
        combgates = '( COMB2 COMB)
        seqgates = '()

        map_combinational
        altera_tag_COMB
        foreach gt (instances @Netlist) {
                if(!(isinlist @gt._gatetype._name @combgates)) (continue)
                if ( isnull @gt.%alttag) (continue)
                    prepend seqgates @gt
        }
        foreach gt @seqgates {
                altera_opt_area_peepCOMB @gt
        }
        lo_removedups @Netlist
}

func altera_opt_area_peepCOMB (abstract instance gt) {
        list glist
        abstract instance ngt
        int icost newcost

        glist = (bld @gt)
        gt.%gtboundary = 1
        #println @gt._name
        opt_area_seq_gateboundary @gt &glist
        foreach ngt @glist (ngt.%gtboundary = ())
        pushdesign
        if(lo_specifycutlist @glist) {
                docut

                /* quick map any generic gates still around */
                for 3 {
                        optpass '{
                                where gate
                                reduction 1
                        }
                }
                icost = (areacost @Netlist)
                copydesign 0
                altera_opt_area_peepCOMB_jiggle
                newcost = (areacost @Netlist)
                if(@icost < @newcost) ( restoredesign 0 )
                splicecut
        }
        popdesign
}

func altera_opt_area_peepCOMB_jiggle() {
        list pair

        flattenmodel 1
        lo_constant_prop @Netlist
        lo_removedups @Netlist
        /* map gates that got left, but don't be noisy about it */
        optpass '{
                where gate
                reduction 1
        }
        foreach pair '((1 4)(2 5)(3 6)(4 6)(5 7)) {
                optpass (assn '{
                        where everywhere
                        reduction 1
                        numin @pair[0]
                        maxiwidth @pair[1]
                })
                shortgates
                cleanup
        }
        optpass '{
                where everywhere
                reduction 1
                numin 1
                maxiwidth 3
        }
}


